program define table8_dynan

* create a table showing how much more deleveraging is needed 

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table8_dynan_$mydate, replace
  capture log close
  file open myfile using "logfiles/table8_dynan_$mydate.txt", write replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
* drop if _n > 10000

* create the sample variables:  

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1

  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=2007 | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 

* let's include everyone!

  *gen insamp = (cons_samp==1) & (retsamp==0) & (hosamp==1)
  *drop if insamp == 0
  quietly replace mort_to_hv = 0 if mort_to_hv == . & hage~=.

* generate comparison variables

    gen bench = l6.mort_to_hv
    replace bench = .9 if (homeown - l6.homeown == 1) 
    quietly gen add_delev = hsval*(mort_to_hv - bench) if yr == 2011
    replace add_delev = 0 if add_delev < 0
    gen add_delev_to_y = add_delev/l2.myprev
    *gen add_delev_to_y = add_delev/((1/3)*(l2.myprev+l4.myprev+l6.myprev))


    gen delev1 = add_delev_to_y <=0 
    gen delev2 = add_delev_to_y > 0    & add_delev_to_y <= .083
    gen delev3 = add_delev_to_y > .083 & add_delev_to_y <= .25
    gen delev4 = add_delev_to_y > .25  & add_delev_to_y <= .5 
    gen delev5 = add_delev_to_y > .5   & add_delev_to_y <= 1
    gen delev6 = add_delev_to_y > 1    & add_delev_to_y <= 2
    gen delev7 = add_delev_to_y > 2    & add_delev_to_y <= 3
    gen delev8 = add_delev_to_y > 3    & add_delev_to_y ~=.

    file write myfile _column(43) "      Table 8" _n 
    file write myfile _column(43) "Deleveraging to Come" _n _n _n
  
    local r1 "  No deleveraging needed"
    local r2 "  0-1 months of income"
    local r3 "  2-3 months of income"
    local r4 "  3-6 months of income"
    local r5 "  6-12 months of income"
    local r6 "  1-2 years of income"
    local r7 "  2-3 years of income"
    local r8 "  3+ years of income"

    file write myfile _column(20) %-20s "Amount of Deleveraging Needed to Bring Mortgage Leverage to 2005 levels" _n _n _n
    file write myfile _column(20) %-20s ///
        _n _n


  forvalues nnn = 1/8 {
      quietly summ delev`nnn' [w=wgt] if add_delev_to_y~=., detail
      scalar stat`nnn' = r(mean)
      file write myfile _column(20) %-20s "`r`nnn''" ///
        _column(45) %6.3f (stat`nnn') ///
        _n
      
   } 
   file write myfile _n
   file write myfile _column(20) %-100s "Note.  Samples include all households for whom I can do comparison" _n
   file write myfile _column(20) %-100s "Note.  Income equals that reported in the 2009 survey." _n
   file close myfile   
 
capture log close

end
